/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import io.github.fabricators_of_create.porting_lib.extensions.extensions.ResourceLocationExtensions;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.RegistryArgument;

public class TagsForCommand {
    protected static final Dynamic2CommandExceptionType VALUE_NOT_FOUND = new Dynamic2CommandExceptionType((type, name) -> class_2561.method_43469((String)"command.mantle.tags_for.not_found", (Object[])new Object[]{type, name}));
    private static final class_2561 NO_HELD_BLOCK = class_2561.method_43471((String)"command.mantle.tags_for.no_held_block");
    private static final class_2561 NO_HELD_ENTITY = class_2561.method_43471((String)"command.mantle.tags_for.no_held_entity");
    private static final class_2561 NO_HELD_POTION = class_2561.method_43471((String)"command.mantle.tags_for.no_held_potion");
    private static final class_2561 NO_HELD_FLUID = class_2561.method_43471((String)"command.mantle.tags_for.no_held_fluid");
    private static final class_2561 NO_HELD_ENCHANTMENT = class_2561.method_43471((String)"command.mantle.tags_for.no_held_enchantment");
    private static final class_2561 NO_TARGETED_ENTITY = class_2561.method_43471((String)"command.mantle.tags_for.no_targeted_entity");
    private static final class_2561 NO_TARGETED_BLOCK_ENTITY = class_2561.method_43471((String)"command.mantle.tags_for.no_targeted_block_entity");
    private static final class_2561 NO_TAGS = class_2561.method_43471((String)"command.mantle.tags_for.no_tags");

    public static void register(LiteralArgumentBuilder<class_2168> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(source -> MantleCommand.requiresDebugInfoOrOp(source, 2))).then(class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"type", RegistryArgument.registry()).suggests(MantleCommand.REGISTRY).then(class_2170.method_9244((String)"name", (ArgumentType)class_2232.method_9441()).suggests(MantleCommand.REGISTRY_VALUES).executes(TagsForCommand::runForId))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"held").then(class_2170.method_9247((String)"item").executes(TagsForCommand::heldItem))).then(class_2170.method_9247((String)"block").executes(TagsForCommand::heldBlock))).then(class_2170.method_9247((String)"enchantment").executes(TagsForCommand::heldEnchantments))).then(class_2170.method_9247((String)"fluid").executes(TagsForCommand::heldFluid))).then(class_2170.method_9247((String)"entity").executes(TagsForCommand::heldEntity))).then(class_2170.method_9247((String)"potion").executes(TagsForCommand::heldPotion)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"targeted").then(class_2170.method_9247((String)"block_entity").executes(TagsForCommand::targetedTileEntity))).then(class_2170.method_9247((String)"entity").executes(TagsForCommand::targetedEntity)));
    }

    private static <T> int printOwningTags(CommandContext<class_2168> context, class_2378<T> registry, T value) {
        class_5250 output = class_2561.method_43469((String)"command.mantle.tags_for.success", (Object[])new Object[]{registry.method_30517().method_29177(), registry.method_10221(value)});
        List<class_2960> tags = registry.method_40265(registry.method_10206(value)).stream().flatMap(class_6880::method_40228).map(class_6862::comp_327).toList();
        if (tags.isEmpty()) {
            output.method_27693("\n* ").method_10852(NO_TAGS);
        } else {
            tags.stream().sorted(ResourceLocationExtensions::compareNamespaced).forEach(tag -> output.method_27693("\n* " + tag));
        }
        ((class_2168)context.getSource()).method_9226(() -> output, true);
        return tags.size();
    }

    private static <T> int runForResult(CommandContext<class_2168> context, class_2378<T> registry) throws CommandSyntaxException {
        class_2960 name = (class_2960)context.getArgument("name", class_2960.class);
        Object value = registry.method_10223(name);
        if (value == null) {
            throw VALUE_NOT_FOUND.create((Object)registry.method_30517().method_29177(), (Object)name);
        }
        return TagsForCommand.printOwningTags(context, registry, value);
    }

    private static int runForId(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2378<?> result = RegistryArgument.getResult(context, "type");
        return TagsForCommand.runForResult(context, result);
    }

    private static int heldItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1792 item = ((class_2168)context.getSource()).method_9207().method_6047().method_7909();
        return TagsForCommand.printOwningTags(context, class_7923.field_41178, item);
    }

    private static int heldBlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1792 item = source.method_9207().method_6047().method_7909();
        class_2248 block = class_2248.method_9503((class_1792)item);
        if (block != class_2246.field_10124) {
            return TagsForCommand.printOwningTags(context, class_7923.field_41175, block);
        }
        source.method_9226(() -> NO_HELD_BLOCK, true);
        return 0;
    }

    private static int heldFluid(CommandContext<class_2168> context) throws CommandSyntaxException {
        FluidStack fluidStack;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        Storage handler = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)class_1268.field_5808));
        if (handler != null && (fluidStack = TransferUtil.getFirstFluid((Storage)handler)) != null && !fluidStack.isEmpty()) {
            class_3611 fluid = fluidStack.getFluid();
            return TagsForCommand.printOwningTags(context, class_7923.field_41173, fluid);
        }
        source.method_9226(() -> NO_HELD_FLUID, true);
        return 0;
    }

    private static int heldPotion(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1799 stack = source.method_9207().method_6047();
        class_1842 potion = class_1844.method_8063((class_1799)stack);
        if (potion != class_1847.field_8984) {
            return TagsForCommand.printOwningTags(context, class_7923.field_41179, potion);
        }
        source.method_9226(() -> NO_HELD_POTION, true);
        return 0;
    }

    private static int heldEnchantments(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1799 stack = source.method_9207().method_6047();
        Map enchantments = class_1890.method_8222((class_1799)stack);
        if (!enchantments.isEmpty()) {
            int totalTags = 0;
            for (class_1887 enchantment : enchantments.keySet()) {
                totalTags += TagsForCommand.printOwningTags(context, class_7923.field_41176, enchantment);
            }
            return totalTags;
        }
        source.method_9226(() -> NO_HELD_ENCHANTMENT, true);
        return 0;
    }

    private static int heldEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1799 stack = source.method_9207().method_6047();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1826) {
            class_1826 egg = (class_1826)class_17922;
            class_1299 type = egg.method_8015(stack.method_7969());
            return TagsForCommand.printOwningTags(context, class_7923.field_41177, type);
        }
        source.method_9226(() -> NO_HELD_ENTITY, true);
        return 0;
    }

    private static int targetedTileEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2586 be;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 level = source.method_9225();
        class_3965 blockTrace = class_1792.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348);
        if (blockTrace.method_17783() == class_239.class_240.field_1332 && (be = level.method_8321(blockTrace.method_17777())) != null) {
            class_2591 type = be.method_11017();
            return TagsForCommand.printOwningTags(context, class_7923.field_41181, type);
        }
        source.method_9226(() -> NO_TARGETED_BLOCK_ENTITY, true);
        return 0;
    }

    private static int targetedEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_243 start = player.method_5836(1.0f);
        class_243 look = player.method_5720();
        double range = Objects.requireNonNull(player.method_5996(PortingLibAttributes.BLOCK_REACH)).method_6194();
        class_243 direction = start.method_1031(look.field_1352 * range, look.field_1351 * range, look.field_1350 * range);
        class_238 bb = player.method_5829().method_1012(look.field_1352 * range, look.field_1351 * range, look.field_1350 * range).method_1012(1.0, 1.0, 1.0);
        class_3966 entityTrace = class_1675.method_18077((class_1937)source.method_9225(), (class_1297)player, (class_243)start, (class_243)direction, (class_238)bb, e -> true);
        if (entityTrace != null) {
            class_1299 target = entityTrace.method_17782().method_5864();
            return TagsForCommand.printOwningTags(context, class_7923.field_41177, target);
        }
        source.method_9226(() -> NO_TARGETED_ENTITY, true);
        return 0;
    }
}

